"use client";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import MediaSelect from "@/components/media/media-select";
import Image from "next/image";
import { Button } from "@/components/ui/button";
import { memo } from "react";

const ProfileInput = memo(function ProfileInputComponent({
  currentProfileInfo,
  handleProfileNameChange,
  handleProfileBioChange,
  handleProfilePictureChange,
}) {
  function handleNameChange(e) {
    handleProfileNameChange(e.target.value);
  }

  function handleBioChange(e) {
    handleProfileBioChange(e.target.value);
  }

  function handleSelectedMedia(media) {
    handleProfilePictureChange(media);
  }

  function handleRemoveMedia() {
    handleProfilePictureChange(null);
  }

  return (
    <div className="grid gap-4">
      {/* Select profile picture if not selected before */}
      {!currentProfileInfo?.profilePicture?.url && (
        <MediaSelect handleSelectedMedia={handleSelectedMedia} />
      )}

      {/* Profile picture preview with change button and remove button */}
      {currentProfileInfo?.profilePicture?.url && (
        <div className="flex flex-col items-center gap-2 p-2 rounded-lg bg-white">
          <Image
            src={currentProfileInfo?.profilePicture?.url}
            alt="Profile Picture"
            width={250}
            height={250}
            unoptimized
            className="h-auto max-w-full rounded-lg"
          />
          <div className="flex gap-2">
            {/* Change Media */}
            <MediaSelect handleSelectedMedia={handleSelectedMedia} />

            {/* Remove Media */}
            <Button variant="outline" onClick={handleRemoveMedia}>
              Remove
            </Button>
          </div>
        </div>
      )}
      <Input
        type="text"
        id="name"
        maxLength={30}
        placeholder="Name"
        onChange={handleNameChange}
        value={currentProfileInfo.name || ""}
      />
      <div className="grid w-full gap-2">
        <Textarea
          maxLength={150}
          placeholder="Write your bio here."
          id="bio"
          onChange={handleBioChange}
          value={currentProfileInfo.bio || ""}
        />
        <p className="text-sm text-muted-foreground">
          Bio must be less than 150 characters.
        </p>
      </div>
    </div>
  );
});
export default ProfileInput;
